userLogin = StudioWidgetWrapper.extend({
	init: function () {
		var thisObj = this
		thisObj._super.apply(thisObj, arguments)
		thisObj.render()
		thisObj.initBusi()

		if (typeof Studio != 'undefined' && Studio) {
			Studio.registerEvents(thisObj, 'goHomepage', 'go Homepage', [])
		}
	},

	render: function () {
		var thisObj = this
        let tenantId;
            if (Studio.inReader) {
                tenantId = STUDIO_DATA.catalogProperties["tenant-id"].value
            } else {
                tenantId = magno.pageService.getCatalogProperties()["tenant-id"].value
            }
        HttpUtils.setCookie("tenant-id", tenantId)
        HttpUtils.setCookie("locale","zh_CN");
		var elem = thisObj.getContainer()

		if (elem) {
			var containerDiv = $('.scfClientRenderedContainer', elem)
			if (containerDiv.length) {
				$(containerDiv).empty()
			} else {
				containerDiv = document.createElement('div')
				containerDiv.className = 'scfClientRenderedContainer'
				$(elem).append(containerDiv)
			}
		}

		thisObj.sksBindItemEvent()
		$(window).resize(function () {
			thisObj.sksRefreshEvents()
		})
	},

	initBusi: function () {
		var thisObj = this
		var widgetProperties = thisObj.getProperties()
		var BasePath = thisObj.getWidgetBasePath() // 本地路径
		var elem = thisObj.getContainer()
		const app  = Vue.createApp({
			data(){
				return {
					BasePath: BasePath,
					imgCode: '',
					account: '',
					password: '',
					inputImgCode: '',
					errorDesc: '',
					needRead: false,
					backgroundClass: 'backgroundClass',
					needVerify: false,
					accountName: '',
					isMobile: false,
				}
			},	
			created() {
				this.getVerifyCode()
				this.checkIsLogin()
				this.isMobile = /Android|webOS|iPhone|iPad|BlackBerry/i.test(
					navigator.userAgent
				)
			},
			watch: {
				account(newVal, oldVal) {
					if (newVal !== oldVal) {
						this.password = ''
					}
				},
			},
			methods: {
				checkIsLogin() {
					const userInfo = JSON.parse(
						window.sessionStorage.getItem('userInfo')
					)
					if (userInfo !== null && userInfo.username) {
						setTimeout(() => {
								thisObj.triggerEvent('goHomepage', {})
							
						}, 1000)
					}
				},
				shouldShowImgCode() {
					connService(
						thisObj,
						`${ds_baseUrl}/identities/isNeedCaptcha`,
						{
							username: this.account,
						},
						'common.PostConnector'
					)
						.then((res) => {
							const { data = [], resp = {} } = res

							if (resp.code !== '0') {
								this.$message.error(resp.message)
							}

							if (data && data.length) {
								this.needVerify = data[0].needVerify

								if (!this.needVerify) {
									this.confirmLogin()
								}
							}
						})
						.catch((e) => {
							this.$message.error(e.response.resMsg)
						})
				},
				// 登录按钮
				validateBeforeSubmit() {
					if (!this.password) {
						this.errorDesc = '请输入密码。'
						this.needVerify = true
						return false
					}
					if (!this.account) {
						this.errorDesc = '请输入用户名。'
						this.needVerify = true
						return false
					}

					if (!this.inputImgCode && this.needVerify) {
						this.errorDesc = '验证码错误。'
						return false
					}

					if (this.needVerify && this.inputImgCode) {
						this.confirmLogin()
						return
					}
					this.confirmLogin()
				},

				// 调登录接口
				confirmLogin() {
					var request = {
						username: this.account,
						password: this.password,
						captcha: this.inputImgCode,
					}
					//
					this.callFlowConn1(
            widgetProperties.loginAPI,
						request,
						this.callLogin,
						this.loginFail,
						'post'
					)
				},

				// 登录接口成功函数
				callLogin(response) {
					if (response) {
                        this.errorDesc = ''
                        let userInfo = {
                            username: response.data[0].username,
                            userId: response.data[0].userId,
                            profile: response.data[0].profile,
                        }
                        HttpUtils.setCookie('isLogged', true)
                        window.sessionStorage.setItem(
                            'userInfo',
                            JSON.stringify(userInfo)
                        )
                        thisObj.triggerEvent('goHomepage', {})
                        
					}
				},
                // 登录失败resMsg
                loginFail(data){
                    this.errorDesc = data.response.resMsg
                    this.getVerifyCode()
                    this.needVerify = true
                },
				// 获取验证码
				getVerifyCode() {
					this.imgCode =
						'/u-route/baas/sys/v1.0/verificationcode?type=login&t=' +
						Date.parse(new Date())
				},
				// 封装flow调用后台
				callFlowConn1: function (service, param, callbackFunc,callbackfail, method) {
					var thisView = this
					let mMethod
					switch (method) {
						case 'get':
							mMethod = 'common.GetConnector'
							break
						case 'post':
							mMethod = 'common.PostConnector'
							break
						case 'put':
							mMethod = 'common.PutConnector'
							break
						default:
							mMethod = 'common.FlowConnector'
							break
					}

					var connector = thisObj.getConnectorInstanceByName(mMethod)
					if (connector) {
						connector.setInputParams({
							service: service,
							needSchema: 'data',
							async: false,
						})
						connector
							.query(param) // 调用接口，以param为入参
							.done(function (response) {
								if (response.resp && response.resp.code) {
									callbackFunc.call(thisView, response)
								}
							})
							.fail(function (response) {
								// 代表接口执行失败
								callbackfail.call(thisView, response)
							})
					}
				},
			},
		})
		app.use(ElementPlus);
		thisObj.vm = app.mount($("#userLogin", elem)[0]);

	},
})
